'This script has been generated by PowerPCB's VB Script Wizard
'It will create reports in Text format (Notepad).
'Modified by Ron Olinyk 15-05-02  hole_pos_report100.bas ver 1.00
'Reports all thru-hole pins and vias in design; name, coord, drill size.

'Arrays of column name and widths. You can modify them to rename, shrink, or expand columns
Const Columns = Array("Name", "Position X", "Position Y", "Drill Size")
Const Widths  = Array(     8,           10,           10,           10)
'Array of column alignment: 0 - Align Left, 1 - Align Right, 2 - Align Center.
Const Align   = Array(     0,            1,            1,            1)

Sub Main

 '*** If error msg occurs due to report too large for Notepad,
 '*** change appnam below to Wordpad or Write and re-run.
 
    appnam = "Notepad" 
	fname = ActiveDocument
	If fname = "" Then
		fname = "Untitled"
	End If
	tempFile = DefaultFilePath & "\temp.txt"
	Open tempFile For Output As #1
	'Output report header
	Print #1, "Hole Pos Report for "; fname; " on "; Now
	Print #1

	StatusBarText = "Generating report..."
	Processed = 0
	ProgressBar = 0
	Total = ActiveDocument.Pins.Count
	'Output table header
	L = UBound(Columns)
	CurCol = 0
	For i = 0 to UBound(Columns)
		OutCell Columns(i)
		L = L + Widths(i)
	Next
	Print #1
	Print #1, String(L, "-")
	'Output table rows
	For Each aPin In GetSortedPins(ActiveDocument)
	  If apin.IsSMD = False Then
		CurCol = 0
		OutCell aPin.Name
		OutCell Format(aPin.PositionX, "0.000")
		OutCell Format(aPin.PositionY, "0.000")
		OutCell aPin.DrillSize
		Print #1
		Processed = Processed + 1
		ProgressBar = Processed * 100 / Total
	  End If	
	Next aPin
	Print #1, String(L, "-")
	Print #1
	Print #1, "Design Thru-Hole count: "; Processed
	Print #1
	Print #1, String(L, "=")
	
	'Output table rows
	For Each aVia In ActiveDocument.Vias
		CurCol = 0
		OutCell aVia.type
		OutCell Format(aVia.PositionX, "0.000")
		OutCell Format(aVia.PositionY, "0.000")
		OutCell aVia.DrillSize
		Print #1
		Processed = Processed + 1
		ProgressBar = Processed * 100 / Total
	Next aVia
	Print #1, String(L, "-")
	Print #1
	Print #1, "Design Via count: "; ActiveDocument.Vias.Count
	Print #1
	Print #1, String(L, "=")

	ProgressBar = -1
	StatusBarText = ""
	Close #1
	FillClipboard
	App = Shell (appnam, 1)
	AppActivate App
	SendKeys "+{Ins}" 'Shift-Ins  Paste
	SendKeys "^{Home}" 'Ctrl+Home  Go to top of the document
End Sub

'Pins are not sorted by default (performance issue), so sort them explicitly in report
Function GetSortedPins(obj As Object)
	Set GetSortedPins = obj.Pins
	GetSortedPins.Sort
End Function


Dim CurCol As Integer	'Current column index staring from 0

Sub OutCell (txt As String)
	w   = Widths(CurCol)
	txt = Left(txt, w)
	n   = w - Len(txt)
	If Align(CurCol) = 0 Then
		Print #1, txt; Space(n + 1);
	ElseIf Align(curCol) = 1 Then
		Print #1, Space(n); txt; Space(1);
	Else
		Print #1, Space(n\2); txt; Space(n - n\2 + 1);
	End If
	CurCol = CurCol + 1
End Sub

Sub FillClipboard
	StatusBarText = "Export Data To Clipboard..."
	' Load whole file to string variable    
	tempFile = DefaultFilePath & "\temp.txt"
	Open tempFile  For Input As #1
	L = LOF(1)
	AllData$ = Input$(L,1)
	Close #1
	'Copy whole data to clipboard
	Clipboard AllData$ 
	Kill tempFile
	StatusBarText = ""
End Sub
